<?php
/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Bunify_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ), 999 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
        require_once get_template_directory() . '/inc/customizer/customizer-upsale/section-pro.php';

        // Register custom section types.
		$manager->register_section_type( 'Fasterly_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Fasterly_Customize_Section_Pro(
				$manager,
				'Fasterly',
				array(
					'title'    => esc_html__( 'Bunify Pro', 'bunify' ),
                    'pro_text' => esc_html__( 'Upgrade to Pro','bunify' ),
                    'pro_url'  => 'https://bunnytheme.com/themes/bunify-pro/',
					'pro_demo_text' => esc_html__( 'Pro Demo','bunify' ),
                    'pro_demo_url'  => 'https://preview.bunnytheme.com/pro/bunify/',
					'help_text' => esc_html__( 'Ask Help?','bunify' ),
                    'help_url'  => 'https://bunnysoftware.ticksy.com/',
                    'priority' => 0
                )
			)
		);
	}
}
// Doing this customizer thang!
Bunify_Customize::get_instance();