<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div class="container">
 *
 * @package Ebooks Collection
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php if ( function_exists( 'wp_body_open' ) ) {
  wp_body_open();
} else {
  do_action( 'wp_body_open' );
} ?>

<?php if ( get_theme_mod('ebooks_collection_preloader', true) != "") { ?>
  <div id="preloader">
    <div id="status">&nbsp;</div>
  </div>
<?php }?>

<a class="screen-reader-text skip-link" href="#content"><?php esc_html_e( 'Skip to content', 'ebooks-collection' ); ?></a>

<div id="pageholder" <?php if( get_theme_mod( 'ebooks_collection_box_layout', false) != "" ) { echo 'class="boxlayout"'; } ?>>

  <div class="header-top">
    <div class="container">
      <div class="row m-0">
        <div class="col-lg-3 col-md-3 align-self-center">
          <div class="logo">
          <?php ebooks_collection_the_custom_logo(); ?>
          <div class="site-branding-text">
            <?php if ( get_theme_mod('ebooks_collection_title_enable',true) != "") { ?>
              <?php if ( is_front_page() && is_home() ) : ?>
                <h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></h1>
              <?php else : ?>
                <p class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></p>
              <?php endif; ?>
            <?php } ?>
            <?php $ebooks_collection_description = get_bloginfo( 'description', 'display' );
            if ( $ebooks_collection_description || is_customize_preview() ) : ?>
              <?php if ( get_theme_mod('ebooks_collection_tagline_enable',false) != "") { ?>
              <span class="site-description"><?php echo esc_html( $ebooks_collection_description ); ?></span>
              <?php } ?>
            <?php endif; ?>
          </div>
        </div>
        </div>
        <div class="col-lg-6 col-md-6 align-self-center">
          <?php if(class_exists('woocommerce')){ ?>
            <div class="search-box my-md-2 my-4">
              <?php get_product_search_form(); ?>
            </div> 
          <?php }?>
        </div>
        <div class="col-lg-3 col-md-3 align-self-center top-bar-sec d-flex justify-content-lg-end justify-content-md-end justify-content-center gap-2 align-self-center top-bar-sec">
          <div class="account">
            <?php if(class_exists('woocommerce')){ ?>
              <span class="account">
                  <?php if ( is_user_logged_in() ) { ?>
                    <a href="<?php echo esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ); ?>" title="<?php esc_attr_e('My Account','ebooks-collection'); ?>"><i class="fas fa-user"></i><span class="screen-reader-text"><?php esc_html_e( 'My Account','ebooks-collection' );?></span></a>
                  <?php }
                  else { ?>
                    <a href="<?php echo esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ); ?>" title="<?php esc_attr_e('Login / Register','ebooks-collection'); ?>"><i class="fas fa-user"></i><span class="screen-reader-text"><?php esc_html_e( 'Login / Register','ebooks-collection' );?></span></a>
                  <?php } ?>
              </span>
            <?php }?>
          </div>
          <span class="wishlist">
            <?php if(defined('YITH_WCWL')){ ?>
              <a class="wishlist_view position-relative" href="<?php echo YITH_WCWL()->get_wishlist_url(); ?>"><i class="far fa-heart"></i>
              <?php $wishlist_count = YITH_WCWL()->count_products(); ?></a>
            <?php }?>
          </span>
          <?php if(class_exists('woocommerce')){ ?>
            <span class="cart_no">
              <a href="<?php if(function_exists('wc_get_cart_url')){ echo esc_url(wc_get_cart_url()); } ?>" title="<?php esc_attr_e( 'shopping cart','ebooks-collection' ); ?>"><i class="fas fa-cart-plus"></i><span class="screen-reader-text"><?php esc_html_e( 'Shopping Cart','ebooks-collection' );?></span></a>
            </span>
          <?php } ?>
        </div>
      </div>
    </div>
  </div>

<div class="header main-stick py-2 <?php echo esc_attr(ebooks_collection_sticky_menu()); ?>">
  <div class="container">
    <div class="row m-0">
      <div class="toggle-nav mobile-stick text-right <?php echo esc_attr(ebooks_collection_sticky_menu()); ?>">
        <button role="tab"><?php esc_html_e('MENU','ebooks-collection'); ?></button>
      </div>
      <div id="mySidenav" class="nav sidenav">
        <nav id="site-navigation" class="main-nav" role="navigation" aria-label="<?php esc_attr_e( 'Top Menu','ebooks-collection' ); ?>">
          <ul class="mobile_nav">
            <?php
              wp_nav_menu( array( 
                'theme_location' => 'primary',
                'container_class' => 'main-menu mx-lg-5' ,
                'items_wrap' => '%3$s',
                'fallback_cb' => 'wp_page_menu',
              ) ); 
             ?>
          </ul>
          <a href="javascript:void(0)" class="close-button"><?php esc_html_e('CLOSE','ebooks-collection'); ?></a>
        </nav>
      </div>
    </div>
  </div>
</div>