<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Fasterly
 */

get_header();
?>
<section id="error-404" class="error-404">
	<div class="container">
		<div class="row">
			<div class="col-lg-12 col-md-12">
				<div class="error-box text-center">	
					<h1 class="error-title-404"><?php esc_html_e('404','fasterly'); ?></h1>
					<h3 class="error-title"><?php esc_html_e('OOPS! THAT PAGE CAN’T BE FOUND.','fasterly'); ?></h3>
					<p><?php esc_html_e('The page you are looking is not available or has been removed. Try going to Home Page by using the button below.','fasterly'); ?></p>
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="btn-1 btn-effect-1 btn-radius-1 "><?php esc_html_e('GO TO HOMEPAGE','fasterly'); ?> <i class="fa fa-angle-double-right"></i></a>
				</div>
			</div> 
		</div>
	</div>
</section>
<?php get_footer(); ?>
