<?php
/**
 * Fasterly Theme Setup
 */
if ( ! function_exists( 'fasterly_theme_setup' ) ) :
function fasterly_theme_setup() {

/**
 * Define Constants
 */
define( 'FASTERLY_THEME_SETTINGS', 'fasterly_theme' );

// Root path/URI.
define( 'FASTERLY_PARENT_DIR', get_template_directory() );
define( 'FASTERLY_PARENT_URI', get_template_directory_uri() );

// Root path/URI.
define( 'FASTERLY_PARENT_INC_DIR', FASTERLY_PARENT_DIR . '/inc');
define( 'FASTERLY_PARENT_INC_URI', FASTERLY_PARENT_URI . '/inc');

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 */
	add_theme_support( 'title-tag' );
	
	add_theme_support( 'custom-header' );
	
	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 */
	add_theme_support( 'post-thumbnails' );
	
	//Add selective refresh for sidebar widget
	add_theme_support( 'customize-selective-refresh-widgets' );
	
	/*
	 * Make theme available for translation.
	 */
	load_theme_textdomain( 'fasterly' );
	
	/*
	 * Custom Logo
	 */
	add_theme_support('custom-logo');
	
	//Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'fasterly_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );
	
	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary_menu' => esc_html__( 'Primary Menu', 'fasterly' ),
	) );

	/*
	 * WooCommerce Plugin Support
	 */
	add_theme_support( 'woocommerce' );
	
	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );
	
	
	// Gutenberg wide images.
	add_theme_support( 'align-wide' );
	
	/**
	 * Set the content width in pixels, based on the theme's design and stylesheet.
	 */
	$GLOBALS['content_width'] = apply_filters( 'fasterly_content_width', 1170 );
}
endif;
add_action( 'after_setup_theme', 'fasterly_theme_setup' );

/**
 * Styles & Scripts.
 */
require_once get_template_directory() . '/inc/enqueue.php';

/**
 * Nav Walker.
 */

require_once get_template_directory() . '/inc/class-wp-bootstrap-navwalker.php';

/**
 * Theme Functions.
 */
require_once get_template_directory() . '/inc/theme-functions.php';

/**
 * Theme Customizer.
 */
require_once get_template_directory() . '/inc/fasterly-customizer.php';
require get_template_directory() . '/inc/customizer/customizer-repeater/functions.php';
