/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

( function( $ ) {

	/**
     * Outputs custom css for responsive controls
     * @param  {[string]} setting customizer setting
     * @param  {[string]} css_selector
     * @param  {[array]} css_prop css property to write
     * @param  {String} ext css value extension eg: px, in
     * @return {[string]} css output
     */
    function range_live_media_load( setting, css_selector, css_prop, ext = '' ) {
        wp.customize(
            setting, function( value ) {
                'use strict';
                value.bind(
                    function( to ){
                        var values          = JSON.parse( to );
                        var desktop_value   = JSON.parse( values.desktop );
                        var tablet_value    = JSON.parse( values.tablet );
                        var mobile_value    = JSON.parse( values.mobile );

                        var class_name      = 'customizer-' + setting;
                        var css_class       = $( '.' + class_name );
                        var selector_name   = css_selector;
                        var property_name   = css_prop;

                        var desktop_css     = '';
                        var tablet_css      = '';
                        var mobile_css      = '';

                        if ( property_name.length == 1 ) {
                            var desktop_css     = property_name[0] + ': ' + desktop_value + ext + ';';
                            var tablet_css      = property_name[0] + ': ' + tablet_value + ext + ';';
                            var mobile_css      = property_name[0] + ': ' + mobile_value + ext + ';';
                        } else if ( property_name.length == 2 ) {
                            var desktop_css     = property_name[0] + ': ' + desktop_value + ext + ';';
                            var desktop_css     = desktop_css + property_name[1] + ': ' + desktop_value + ext + ';';

                            var tablet_css      = property_name[0] + ': ' + tablet_value + ext + ';';
                            var tablet_css      = tablet_css + property_name[1] + ': ' + tablet_value + ext + ';';

                            var mobile_css      = property_name[0] + ': ' + mobile_value + ext + ';';
                            var mobile_css      = mobile_css + property_name[1] + ': ' + mobile_value + ext + ';';
                        }

                        var head_append     = '<style class="' + class_name + '">@media (min-width: 320px){ ' + selector_name + ' { ' + mobile_css + ' } } @media (min-width: 720px){ ' + selector_name + ' { ' + tablet_css + ' } } @media (min-width: 960px){ ' + selector_name + ' { ' + desktop_css + ' } }</style>';

                        if ( css_class.length ) {
                            css_class.replaceWith( head_append );
                        } else {
                            $( "head" ).append( head_append );
                        }
                    }
                );
            }
        );
    }
	// Site title and description.
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title' ).text( to );
		} );
	} );
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );

	// Header text color.
	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( '.site-title, .site-description' ).css( {
					'clip': 'rect(1px, 1px, 1px, 1px)',
					'position': 'absolute'
				} );
			} else {
				$( '.site-title, .site-description' ).css( {
					'clip': 'auto',
					'position': 'relative'
				} );
				$( '.site-title, .site-description' ).css( {
					'color': to
				} );
			}
		} );
	} );
	
	$(document).ready(function ($) {
        $('input[data-input-type]').on('input change', function () {
            var val = $(this).val();
            $(this).prev('.cs-range-value').html(val);
            $(this).val(val);
        });
    })
	
	
	/**
	 * logo_width
	 */
	range_live_media_load( 'fasterly_theme_logo_width', '.logo img, .mobile-logo img', [ 'max-width' ], 'px !important' );
	
	/**
	 * site_ttl_size
	 */
	 
	range_live_media_load( 'fasterly_theme_site_ttl_size', 'h4.site-title', [ 'font-size' ], 'px !important' );
	
	/**
	 * site_desc_size
	 */
	 
	range_live_media_load( 'fasterly_theme_site_desc_size', '.site-description', [ 'font-size' ], 'px !important' );
	
	//fasterly_theme_hdr_left_ttl
	wp.customize(
		'fasterly_theme_hdr_left_ttl', function( value ) {
			value.bind(
				function( newval ) {
					$( '.header-widget .text-animation .text-heading' ).text( newval );
				}
			);
		}
	);
	
	
	//fasterly_theme_hdr_left_txt
	wp.customize(
		'fasterly_theme_hdr_left_txt', function( value ) {
			value.bind(
				function( newval ) {
					$( '.header-widget .text-animation .typewrite' ).text( newval );
				}
			);
		}
	);
	
	//fasterly_theme_hdr_social_ttl
	wp.customize(
		'fasterly_theme_hdr_social_ttl', function( value ) {
			value.bind(
				function( newval ) {
					$( '.header-widget .social-title' ).text( newval );
				}
			);
		}
	);
	
	//fasterly_theme_nav_btn_lbl
	wp.customize(
		'fasterly_theme_nav_btn_lbl', function( value ) {
			value.bind(
				function( newval ) {
					$( '.hdr-btn' ).text( newval );
				}
			);
		}
	);
	
	//fasterly_theme_infromation_title
	wp.customize(
		'fasterly_theme_infromation_title', function( value ) {
			value.bind(
				function( newval ) {
					$( '.info_4 .info-left-4 h2' ).text( newval );
				}
			);
		}
	);
	
	//fasterly_theme_about_title
	wp.customize(
		'fasterly_theme_about_title', function( value ) {
			value.bind(
				function( newval ) {
					$( '.hm-abt .about-right-area .sbttl' ).text( newval );
				}
			);
		}
	);
	
	//fasterly_theme_about_sbttl
	wp.customize(
		'fasterly_theme_about_sbttl', function( value ) {
			value.bind(
				function( newval ) {
					$( '.hm-abt .about-right-area .title' ).text( newval );
				}
			);
		}
	);
	
	//fasterly_theme_about_txt
	wp.customize(
		'fasterly_theme_about_txt', function( value ) {
			value.bind(
				function( newval ) {
					$( '.hm-abt .about-right-area .txt' ).text( newval );
				}
			);
		}
	);
	
	//fasterly_theme_service_title
	wp.customize(
		'fasterly_theme_service_title', function( value ) {
			value.bind(
				function( newval ) {
					$( '.hm-service .section-title-1 .title' ).text( newval );
				}
			);
		}
	);
	
	//fasterly_theme_service_sbttl
	wp.customize(
		'fasterly_theme_service_sbttl', function( value ) {
			value.bind(
				function( newval ) {
					$( '.hm-service .section-title-1 .sbttl' ).text( newval );
				}
			);
		}
	);
	
	//fasterly_theme_service_txt
	wp.customize(
		'fasterly_theme_service_txt', function( value ) {
			value.bind(
				function( newval ) {
					$( '.hm-service .section-title-1 .txt' ).text( newval );
				}
			);
		}
	);
	
	//fasterly_theme_cta_title
	wp.customize(
		'fasterly_theme_cta_title', function( value ) {
			value.bind(
				function( newval ) {
					$( '.hm-cta .cta_content .ttl' ).text( newval );
				}
			);
		}
	);
	
	//fasterly_theme_cta_sbttl
	wp.customize(
		'fasterly_theme_cta_sbttl', function( value ) {
			value.bind(
				function( newval ) {
					$( '.hm-cta .cta_content .txt' ).text( newval );
				}
			);
		}
	);
	
	//fasterly_theme_cta_btn_lbl
	wp.customize(
		'fasterly_theme_cta_btn_lbl', function( value ) {
			value.bind(
				function( newval ) {
					$( '.hm-cta .btn-1' ).text( newval );
				}
			);
		}
	);
	
	//fasterly_theme_blog_title
	wp.customize(
		'fasterly_theme_blog_title', function( value ) {
			value.bind(
				function( newval ) {
					$( '.hm-blog .section-title-1 .title' ).text( newval );
				}
			);
		}
	);
	
	//fasterly_theme_blog_txt
	wp.customize(
		'fasterly_theme_blog_txt', function( value ) {
			value.bind(
				function( newval ) {
					$( '.hm-blog .section-title-1 .txt' ).text( newval );
				}
			);
		}
	);
	
	/**
	 * Container Width
	 */
	wp.customize( 'fasterly_theme_site_cntnr_width', function( value ) {
		
		value.bind( function( fasterly_theme_site_cntnr_width ) {
			var class_name      = 'fasterly_theme_site_cntnr_width'; // Used as id in gfont link
			var css_class       = $( '.' + class_name );			
			
			if (fasterly_theme_site_cntnr_width >= 768 && fasterly_theme_site_cntnr_width < 2000){
				var head_append     = '<style class="' + class_name + '">.container{ max-width: ' + fasterly_theme_site_cntnr_width + 'px;}</style>';
			}

			if ( css_class.length ) {
				css_class.replaceWith( head_append );
			} else {
				$( 'head' ).append( head_append );
			}
			
		});
		
	} );
	
	
	/**
	 * Body font size
	 */
	
	range_live_media_load( 'fasterly_theme_body_font_size', 'body', [ 'font-size' ], 'px' );
	
	/**
	 * Body Letter Spacing
	 */
	
	range_live_media_load( 'fasterly_theme_body_ltr_space', 'body', [ 'letter-spacing' ], 'px' );
	
	/**
	 * fasterly_theme_body_line_height
	 */
	range_live_media_load( 'fasterly_theme_body_line_height', 'body', [ 'line-height' ] );
	
	
	/**
	 * H1 font size
	 */
	range_live_media_load( 'fasterly_theme_h1_font_size', 'h1', [ 'font-size' ], 'px' );
	
	
	/**
	 * H1 line height
	 */
	range_live_media_load( 'fasterly_theme_h1_line_height', 'h1', [ 'line-height' ] );
	
	/**
	 * H1 Letter Spacing
	 */
	 
	range_live_media_load( 'fasterly_theme_h1_ltr_spacing', 'h1', [ 'letter-spacing' ], 'px' );

	
	/**
	 * H2 font size
	 */
	range_live_media_load( 'fasterly_theme_h2_font_size', 'h2', [ 'font-size' ], 'px' );
	
	
	/**
	 * H2 line height
	 */
	range_live_media_load( 'fasterly_theme_h2_line_height', 'h2', [ 'line-height' ]);
	
	/**
	 * H2 Letter Spacing
	 */
	
	range_live_media_load( 'fasterly_theme_h2_ltr_spacing', 'h2', [ 'letter-spacing' ], 'px' );
	
	/**
	 * H3 font size
	 */
	range_live_media_load( 'fasterly_theme_h3_font_size', 'h3', [ 'font-size' ], 'px' );
	
	/**
	 * H3 line height
	 */
	range_live_media_load( 'fasterly_theme_h3_line_height', 'h3', [ 'line-height' ]);
	
	/**
	 * H3 Letter Spacing
	 */
	
	range_live_media_load( 'fasterly_theme_h3_ltr_spacing', 'h3', [ 'letter-spacing' ], 'px' );
	
	
	/**
	 * H4 font size
	 */
	range_live_media_load( 'fasterly_theme_h4_font_size', 'h4', [ 'font-size' ], 'px' );
	
	/**
	 * H4 line height
	 */
	range_live_media_load( 'fasterly_theme_h4_line_height', 'h4', [ 'line-height' ]);
	
	/**
	 * H4 Letter Spacing
	 */
	
		range_live_media_load( 'fasterly_theme_h4_ltr_spacing', 'h4', [ 'letter-spacing' ], 'px' );
	
	/**
	 * H5 font size
	 */
	range_live_media_load( 'fasterly_theme_h5_font_size', 'h5', [ 'font-size' ], 'px' );
	
	/**
	 * H5 line height
	 */
	range_live_media_load( 'fasterly_theme_h5_line_height', 'h5', [ 'line-height' ]);
	
	/**
	 * H5 Letter Spacing
	 */
	
	range_live_media_load( 'fasterly_theme_h5_ltr_spacing', 'h5', [ 'letter-spacing' ], 'px' );
	
	/**
	 * H6 font size
	 */
	range_live_media_load( 'fasterly_theme_h6_font_size', 'h6', [ 'font-size' ], 'px' );
	
	/**
	 * H6 line height
	 */
	range_live_media_load( 'fasterly_theme_h6_line_height', 'h6', [ 'line-height' ]);
	
	/**
	 * H6 Letter Spacing
	 */
	
	range_live_media_load( 'fasterly_theme_h6_ltr_spacing', 'h6', [ 'letter-spacing' ], 'px' );
	
} )( jQuery );