<?php
function fasterly_footer_option_data( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	// Footer Panel // 
	$wp_customize->add_panel( 
		'footer_section', 
		array(
			'priority'      => 34,
			'capability'    => 'edit_theme_options',
			'title'			=> __('Footer', 'fasterly'),
		) 
	);
	
	/*=========================================
	Footer Copyright
	=========================================*/	
	$wp_customize->add_section(
        'footer_copy_option',
        array(
            'title' 		=> __('Footer Copyright','fasterly'),
			'panel'  		=> 'footer_section',
			'priority'      => 3,
		)
    );
	// Head
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_footer_copy_head'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_text',
			'priority' => 1,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_footer_copy_head',
		array(
			'type' => 'hidden',
			'label' => __('Setting','fasterly'),
			'section' => 'footer_copy_option',
		)
	);
	
	
	// hide/show
	$wp_customize->add_setting( 
		FASTERLY_THEME_SETTINGS .'_hs_footer_copy' , 
			array(
			'default' => '1',
			'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_checkbox',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_hs_footer_copy', 
		array(
			'label'	      => esc_html__( 'Hide/Show', 'fasterly' ),
			'section'     => 'footer_copy_option',
			'type'        => 'checkbox'
		) 
	);	
	
	// Copyright Head
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_footer_c_head'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_text',
			'priority' => 4,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_footer_c_head',
		array(
			'type' => 'hidden',
			'label' => __('Copyright','fasterly'),
			'section' => 'footer_copy_option',
		)
	);
	
	
	//  Text // 
	$fasterlycopyright = esc_html__('Copyright &copy; [current_year] [site_title] | Powered by [theme_author]', 'fasterly' );
	$wp_customize->add_setting(
    	FASTERLY_THEME_SETTINGS .'_fc_txt',
    	array(
	        'default'			=> $fasterlycopyright,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_html',
			'priority' => 3,
		)
	);	
	
	$wp_customize->add_control( 
		FASTERLY_THEME_SETTINGS .'_fc_txt',
		array(
		    'label'   => __('Copyright','fasterly'),
		    'section' => 'footer_copy_option',
			'type'           => 'textarea',
		)  
	);
	
	
	// Social Head
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_footer_s_head'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_text',
			'priority' => 4,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_footer_s_head',
		array(
			'type' => 'hidden',
			'label' => __('Social Icon','fasterly'),
			'section' => 'footer_copy_option',
		)
	);
	
	
	// hide/show
	$wp_customize->add_setting( 
		FASTERLY_THEME_SETTINGS .'_hs_footer_social' , 
			array(
			'default' => '1',
			'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_checkbox',
			'priority' => 4,
		) 
	);
	
	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_hs_footer_social', 
		array(
			'label'	      => esc_html__( 'Hide/Show', 'fasterly' ),
			'section'     => 'footer_copy_option',
			'type'        => 'checkbox'
		) 
	);	
	
	
	// Title // 
	$wp_customize->add_setting(
    	FASTERLY_THEME_SETTINGS.'_footer_social_ttl',
    	array(
			'sanitize_callback' => 'fasterly_sanitize_html',
			'transport'         => $selective_refresh,
			'capability' => 'edit_theme_options',
			'priority' => 5,
		)
	);	

	$wp_customize->add_control( 
		FASTERLY_THEME_SETTINGS.'_footer_social_ttl',
		array(
		    'label'   		=> __('Title','fasterly'),
		    'section' 		=> 'footer_copy_option',
			'type'		 =>	'text',
		)  
	);
	
	/**
	 * Customizer Repeater
	 */
	 if ( function_exists( 'fasterly_get_social_icon_default' ) ) :
		$fasterly_theme_social_icons	= fasterly_get_social_icon_default();
	else:
		$fasterly_theme_social_icons	= '';
	endif;
		$wp_customize->add_setting( FASTERLY_THEME_SETTINGS.'_footer_social_icons', 
			array(
			 'sanitize_callback' => 'fasterly_repeater_sanitize',
			 'priority' => 6,
			 'default' => $fasterly_theme_social_icons
		)
		);
		
		$wp_customize->add_control( 
			new FASTERLY_Repeater( $wp_customize, 
				FASTERLY_THEME_SETTINGS.'_footer_social_icons', 
					array(
						'label'   => esc_html__('Social Icons','fasterly'),
						'section' => 'footer_copy_option',
						'customizer_repeater_icon_control' => true,
						'customizer_repeater_link_control' => true,
					) 
				) 
			);
			
	/*=========================================
	Footer Background
	=========================================*/	
	$wp_customize->add_section(
        'footer_bg_option',
        array(
            'title' 		=> __('Footer Background','fasterly'),
			'panel'  		=> 'footer_section',
			'priority'      => 3,
		)
    );
	// Head
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_footer_bg_head'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_text',
			'priority' => 1,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_footer_bg_head',
		array(
			'type' => 'hidden',
			'label' => __('Footer Background','fasterly'),
			'section' => 'footer_bg_option',
		)
	);	

// Image // 
    $wp_customize->add_setting( 
    	FASTERLY_THEME_SETTINGS .'_footer_bg_img' , 
    	array(
			'default' 			=> esc_url(get_template_directory_uri() .'/assets/image/footer/footer_bg_2.jpg'),
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_url',	
			'priority' => 12,
		) 
	);
	
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize , FASTERLY_THEME_SETTINGS .'_footer_bg_img' ,
		array(
			'label'          => esc_html__( 'Background Image', 'fasterly'),
			'section'        => 'footer_bg_option',
		) 
	));
	
	
	// Overlay Color
	$wp_customize->add_setting(
	FASTERLY_THEME_SETTINGS .'_footer_bg_overlay_clr', 
	array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
		'default' => '#000000',
		'priority' => 12
    ));
	
	$wp_customize->add_control( 
		new WP_Customize_Color_Control
		($wp_customize, 
			FASTERLY_THEME_SETTINGS .'_footer_bg_overlay_clr', 
			array(
				'label'      => __( 'Overlay Color', 'fasterly' ),
				'section'    => 'footer_bg_option',
			) 
		) 
	);
	
	// opacity
	if ( class_exists( 'Fasterly_Customizer_Range_Control' ) ) {
		$wp_customize->add_setting(
			FASTERLY_THEME_SETTINGS .'_footer_bg_opacity',
			array(
				'default'	      => '0.8',
				'capability'     	=> 'edit_theme_options',
				'sanitize_callback' => 'fasterly_sanitize_range_value',
				'priority' => 12,
			)
		);
		$wp_customize->add_control( 
		new Fasterly_Customizer_Range_Control( $wp_customize, FASTERLY_THEME_SETTINGS .'_footer_bg_opacity', 
			array(
				'label'      => __( 'opacity', 'fasterly' ),
				'section'  => 'footer_bg_option',
				 'media_query'   => false,
					'input_attr'    => array(
						'desktop' => array(
							'min'           => 0,
							'max'           => 0.9,
							'step'          => 0.1,
							'default_value' => 0.9,
						),
					),
			) ) 
		);
	}	
}
add_action( 'customize_register', 'fasterly_footer_option_data' );
// Footer selective refresh
function fasterly_footer_partials( $wp_customize ){
	//fasterly_theme_footer_social_ttl
	$wp_customize->selective_refresh->add_partial( 'fasterly_theme_footer_social_ttl', array(
		'selector'            => '.footer-bottom .right-widget .social-title',
		'settings'            => 'fasterly_theme_footer_social_ttl',
		'render_callback'  => 'fasterly_theme_footer_social_ttl_render_callback',
	) );
	}

add_action( 'customize_register', 'fasterly_footer_partials' );

// fasterly_theme_footer_social_ttl
function fasterly_theme_footer_social_ttl_render_callback() {
	return get_theme_mod( 'fasterly_theme_footer_social_ttl' );
}