<?php
function fasterly_header_settings( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	/*=========================================
	Header Settings Panel
	=========================================*/
	$wp_customize->add_panel( 
		'header_section', 
		array(
			'priority'      => 2,
			'capability'    => 'edit_theme_options',
			'title'			=> __('Site Header', 'fasterly'),
		) 
	);
	
	/*=========================================
	Fasterly Site Identity
	=========================================*/
	$wp_customize->add_section(
        'title_tagline',
        array(
        	'priority'      => 1,
            'title' 		=> __('Site Identity','fasterly'),
			'panel'  		=> 'header_section',
		)
    );
	// Head
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS.'_logo_head'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_text',
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS.'_logo_head',
		array(
			'type' => 'hidden',
			'label' => __('Logo','fasterly'),
			'section' => 'title_tagline',
			'priority' => 1,
		)
	);
	
	/*=========================================
	Top  Header Section
	=========================================*/
	$wp_customize->add_section(
        'top_header',
        array(
        	'priority'      => 2,
            'title' 		=> __('Top Header','fasterly'),
			'panel'  		=> 'header_section',
		)
    );
	
	/*=========================================
	Header Navigation Bar
	=========================================*/	
	$wp_customize->add_section(
        'header_nav_bar',
        array(
        	'priority'      => 4,
            'title' 		=> __('Navigation Bar','fasterly'),
			'panel'  		=> 'header_section',
		)
    );
	
	/*=========================================
	Header Search
	=========================================*/	
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS.'_hdr_nav_search'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_text',
			'priority' => 1,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS.'_hdr_nav_search',
		array(
			'type' => 'hidden',
			'label' => __('Search','fasterly'),
			'section' => 'header_nav_bar',
		)
	);
	$wp_customize->add_setting( 
		FASTERLY_THEME_SETTINGS.'_hs_search' , 
			array(
			'default' => '',
			'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_checkbox',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS.'_hs_search', 
		array(
			'label'	      => esc_html__( 'Hide/Show', 'fasterly' ),
			'section'     => 'header_nav_bar',
			'type'        => 'checkbox'
		) 
	);	
	
	/*=========================================
	Header Cart
	=========================================*/
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS.'_hdr_nav_cart'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_text',
			'priority' => 3,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS.'_hdr_nav_cart',
		array(
			'type' => 'hidden',
			'label' => __('Cart','fasterly'),
			'section' => 'header_nav_bar',
		)
	);
	$wp_customize->add_setting( 
		FASTERLY_THEME_SETTINGS.'_hs_cart' , 
			array(
			'default' => '1',
			'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_checkbox',
			'priority' => 4,
		) 
	);
	
	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS.'_hs_cart', 
		array(
			'label'	      => esc_html__( 'Hide/Show', 'fasterly' ),
			'section'     => 'header_nav_bar',
			'type'        => 'checkbox'
		) 
	);	
	
	/*=========================================
	Header Button
	=========================================*/
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS.'_hdr_nav_btn'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_text',
			'priority' => 5,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS.'_hdr_nav_btn',
		array(
			'type' => 'hidden',
			'label' => __('Button','fasterly'),
			'section' => 'header_nav_bar',
		)
	);
	

	$wp_customize->add_setting( 
		FASTERLY_THEME_SETTINGS.'_hs_nav_btn' , 
			array(
			'default' => '1',
			'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_checkbox',
			'priority' => 6,
		) 
	);
	
	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS.'_hs_nav_btn', 
		array(
			'label'	      => esc_html__( 'Hide/Show', 'fasterly' ),
			'section'     => 'header_nav_bar',
			'type'        => 'checkbox'
		) 
	);	
	
	
	// Button Label // 
	$wp_customize->add_setting(
    	FASTERLY_THEME_SETTINGS.'_nav_btn_lbl',
    	array(
			'sanitize_callback' => 'fasterly_sanitize_html',
			'transport'         => $selective_refresh,
			'capability' => 'edit_theme_options',
			'priority' => 7,
		)
	);	

	$wp_customize->add_control( 
		FASTERLY_THEME_SETTINGS.'_nav_btn_lbl',
		array(
		    'label'   		=> __('Button Label','fasterly'),
		    'section' 		=> 'header_nav_bar',
			'type'		 =>	'text'
		)  
	);
	
	// Button Link // 
	$wp_customize->add_setting(
    	FASTERLY_THEME_SETTINGS.'_nav_btn_link',
    	array(
			'sanitize_callback' => 'fasterly_sanitize_url',
			'capability' => 'edit_theme_options',
			'priority' => 8,
		)
	);	

	$wp_customize->add_control( 
		FASTERLY_THEME_SETTINGS.'_nav_btn_link',
		array(
		    'label'   		=> __('Button Link','fasterly'),
		    'section' 		=> 'header_nav_bar',
			'type'		 =>	'text'
		)  
	);
	
	
	
	/*=========================================
	Sticky Header
	=========================================*/	
	$wp_customize->add_section(
        'sticky_header_set',
        array(
        	'priority'      => 4,
            'title' 		=> __('Sticky Header','fasterly'),
			'panel'  		=> 'header_section',
		)
    );
	
	// Heading
	$wp_customize->add_setting(
		'sticky_head'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_text',
			'priority' => 1,
		)
	);

	$wp_customize->add_control(
	'sticky_head',
		array(
			'type' => 'hidden',
			'label' => __('Sticky Header','fasterly'),
			'section' => 'sticky_header_set',
		)
	);
	$wp_customize->add_setting( 
		'hide_show_sticky' , 
			array(
			'default' => '1',
			'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_checkbox',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'hide_show_sticky', 
		array(
			'label'	      => esc_html__( 'Hide/Show', 'fasterly' ),
			'section'     => 'sticky_header_set',
			'type'        => 'checkbox'
		) 
	);	
}
add_action( 'customize_register', 'fasterly_header_settings' );

// Header selective refresh
function fasterly_header_partials( $wp_customize ){	
	// fasterly_theme_nav_btn_lbl
	$wp_customize->selective_refresh->add_partial( 'fasterly_theme_nav_btn_lbl', array(
		'selector'            => '.hdr-btn',
		'settings'            => 'fasterly_theme_nav_btn_lbl',
		'render_callback'  => 'fasterly_theme_nav_btn_lbl_render_callback',
	) );
	
	}

add_action( 'customize_register', 'fasterly_header_partials' );


// fasterly_theme_nav_btn_lbl
function fasterly_theme_nav_btn_lbl_render_callback() {
	return get_theme_mod( 'fasterly_theme_nav_btn_lbl' );
}