<?php
/**
 * Template part for displaying page content in page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Fasterly
 */
$fasterly_theme_enable_post_excerpt = get_theme_mod( 'fasterly_theme_enable_post_excerpt');
$fasterly_theme_enable_post_db 		= get_theme_mod( 'fasterly_theme_enable_post_db','1');
$fasterly_theme_enable_post_cat 	= get_theme_mod( 'fasterly_theme_enable_post_cat','1');
$fasterly_theme_enable_post_author 	= get_theme_mod( 'fasterly_theme_enable_post_author','1');
$fasterly_theme_enable_post_comments= get_theme_mod( 'fasterly_theme_enable_post_comments','1');
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('post-item-2'); ?>>
	<?php if ( has_post_thumbnail() ) { ?>
		<figure class="post-image">
			 <a href="<?php esc_url(the_permalink()); ?>">
				<?php 
					the_post_thumbnail();
				?>
			 </a>
			 <?php if($fasterly_theme_enable_post_db=='1'): ?>	
				<span class="posted-on post-date">
					<a href="<?php echo esc_url(get_month_link(get_post_time('Y'),get_post_time('m'))); ?>"> <span class="post-date"><?php echo esc_html(get_the_date('j')); ?></span><?php echo esc_html(get_the_date('M')); ?></a>
				</span>
			<?php endif; ?>
		</figure>
	<?php } ?>
	<div class="post-content">
		<?php if($fasterly_theme_enable_post_cat=='1'): ?>
			<div class="post-meta up">
				<div class="post-line-1">
					<span class="post-list">
						<ul class="post-categories-2">
							<li><?php the_category(', '); ?></li>
						</ul>
					</span>
				</div>
			</div>
		<?php endif; ?>	
		<div class="blog-meta">
			 <?php if($fasterly_theme_enable_post_author=='1'): ?>
				<a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ) ));?>"><i class="fa fa-user"></i> <?php esc_html_e('By','fasterly'); ?> <?php the_author(); ?></a>
			<?php endif; ?>	
			
			 <?php if($fasterly_theme_enable_post_comments=='1'): ?>
				<a href="javascript:void(0)"><i class="fa fa-comment"></i><?php echo esc_html(get_comments_number($post->ID)); ?> <?php esc_html_e('Comments','fasterly'); ?></a>
			<?php endif; ?>	
		</div>
		<?php     
			if ( is_single() ) :
			
			the_title('<h5 class="post-title">', '</h5>' );
			
			else:
			
			the_title( sprintf( '<h5 class="post-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h5>' );
			
			endif; 
		?> 
		<?php 
		  if($fasterly_theme_enable_post_excerpt == 'true' && !is_single()):
		  
			the_excerpt();
			if ( function_exists( 'fasterly_execerpt_link' ) ) : fasterly_execerpt_link(); endif; 
			
			else:
			
			the_content( 
					sprintf( 
						__( 'Read More', 'fasterly' ), 
						'<span class="screen-reader-text">  '.esc_html(get_the_title()).'</span>' 
					) 
				);
				
			endif;	
		  ?>
	</div>
</article>